from log import logger
from typing import List, Set, Dict

from customTypes import *



class SlotReq:
    def __init__(self, tipoSlot: TipoSlot, slotId:str, numIscritti:int, idInsegnamento:int, numSlot: int=1):
        '''struttura per gestire info del singolo Slot (Generico, Scelto, Preferito)'''
        self.numSlot:int = numSlot
        self.tipoSlot:TipoSlot = tipoSlot
        self.setDocenti:Set[int] = set()
        self.slotId = slotId
        self.numIscritti = numIscritti
        self.idInsegnamento = idInsegnamento # ptr back to Insegnamento
        self.tipoLezione:TipoLezione = TipoLezione.Lezione
        self.tipoLocale:TipoLocale = TipoLocale.Aula
        self.tipoErogazione:TipoErogazione = TipoErogazione.Presenza
        self.idSlotAllocato:int = -1 
        self.squadra:Squadra = Squadra.NoSquadra
        self.note:str = ""
        '''usato solo se tipoSlot in [SlotScelto, SlotScelto_giorno, SlotScelto_fasciaOraria].
        
        Values:
            SlotScelto: contiene l'id corrispondente allo slot preciso (al primo slot in caso di più slot consecutivi)
            SlotScelto_giorno: contiene l'offset del giorno nella matrice (idGiorno * N_SLOT_GIORNO)
            SlotScelto_fasciaOraria: contiene l'offset della fascia oraria nella matrice per il Lun
        '''
        self.N_GIORNI_SETTIMANA:int = 5
        self.N_SLOT_GIORNO:int = 7
        self.preseElettriche:PreseElettriche = PreseElettriche.No
        self.log:logger = logger()
        
    def __str__(self):
        res:str = self.slotId + " num slot: " + str(self.numSlot) + " docenti: " + str(self.setDocenti)
        return res
    
    def addDocente(self, docente:int):
        '''aggiunta singolo docente per lo slot corrente'''
        self.setDocenti.add(docente)
        
    def setIdSlotAllocato(self, day:str, fasciaOraria:str):
        '''Set self.idSlotAllocato. Gestisco il caso in cui day == "Indifferente" or fasciaOraria == "Indifferente".
        Se self.tipoSlot != SlotScelto => non ha effetto.
        
        Args:
            day (str): identificativo del giorno nella sintassi prevista per il file xml
            fasciaOraria (str): identificativo della fascia oraria nella sintassi prevista per il file xml
        '''
        if self.tipoSlot != TipoSlot.SlotScelto:
            self.log.error_log("SlotReq.setIdSlotAllocato(): chiamata da uno slot di tipo verso da SlotScelto")
            return
        self.daySlotAllocato, self.hourSlotAllocato = getIdSlotFromString(day, fasciaOraria)
        if self.daySlotAllocato == -1 and self.hourSlotAllocato == -1:
            if day == "Indifferente":
                self.tipoSlot = TipoSlot.SlotScelto_fasciaOraria
                self.hourSlotAllocato = getIdFasciaOrariaFromString(fasciaOraria)
            elif fasciaOraria == "Indifferente":
                self.tipoSlot = TipoSlot.SlotScelto_giorno
                self.daySlotAllocato = getIdGiornoFromString(day)

